# rm-rf.t
use 5.12.0;
use warnings;
use Test::More qw( no_plan );
use lib '.';
use CreateSubdirs ();

# Manually make some temporary directories and play with chmod.
# Try manually deleting them with rm -rf.

say "Perl version:       $]";
my $sdir = $$ . '_base';
say "subdir name:        $sdir";

my $tdir = '/tmp';
#chdir $tdir or die "Unable to change to $tdir: $!";

my (@altered, $rv);

note("Creating empty subdirs");
@altered = CreateSubdirs::create_subdirs($tdir, $sdir . '_nofile', 'no_create_file');

for my $alt (@altered) {
    my $rv = system(qq|rm -rf $alt|);
    Test::More::is($rv >> 8, 0, "Able to rm -rf $alt");
}

note("Creating subdirs with a file in each");
@altered = CreateSubdirs::create_subdirs($tdir, $sdir);

# We expect rm -rf to fail on all except the 0700 subdirectory
for my $alt (@altered[0..6]) {
    my $rv = system(qq|rm -rf $alt|);
    Test::More::is($rv >> 8, 1, "Unable to rm -rf $alt");
}
$rv = system(qq|rm -rf $altered[7]|);
Test::More::is($rv >> 8, 0, "Able to rm -rf $altered[7]");

