# rm-rf.t
use 5.12.0;
use warnings;
use Test::More qw( no_plan );
use lib '.';
use CreateSubdirs ();

# Manually make some temporary directories and play with chmod.
# Try manually deleting them with rm -rf.

say "Perl version:       $]";
my $sdir = $$ . '_base_nofile';
say "subdir name:        $sdir";

my $tdir = '/tmp';

my (@altered, $rv);

note("Creating empty subdirs");
@altered = CreateSubdirs::create_subdirs($tdir, $sdir, 'no_create_file');

for my $alt (@altered) {
    my $rv = system(qq|rm -rf $alt|);
    Test::More::is($rv >> 8, 0, "Able to rm -rf $alt");
}

