# fprmtree-trad.t
use 5.12.0;
use warnings;
use File::Path ();
use Test::More qw( no_plan );
use lib '.';
use CreateSubdirs ();

# Manually make some temporary directories and play with chmod.
# Try manually deleting them with File::Path::rmtree().

say "Perl version:       $]";
say "File::Path version: $File::Path::VERSION";
my $sdir = $$ . '_base';
say "subdir name:        $sdir";

my $tdir = '/tmp';
chdir $tdir or die "Unable to change to $tdir: $!";

my @altered = CreateSubdirs::create_subdirs($tdir, $sdir);

# We expect File::Path::rmtree (unsafe) before 2.13 to remove everything
for my $alt (@altered) {
    my $removed_count = File::Path::rmtree($alt);
    Test::More::is(
        $removed_count,
        2,
        "rmtree (traditional) removed 2 items: file; directory $alt");
}

