# fprmtree-trad-safe.t
use 5.12.0;
use warnings;
use File::Path ();
use Test::More qw( no_plan );
use lib '.';
use CreateSubdirs ();

# Manually make some temporary directories and play with chmod.
# Try manually deleting them with pre-2.13 rmtree() with safe => 1.

say "Perl version:       $]";
say "File::Path version: $File::Path::VERSION";
my $sdir = $$ . '_base';
say "subdir name:        $sdir";

my $tdir = '/tmp';
chdir $tdir or die "Unable to change to $tdir: $!";

my @altered = CreateSubdirs::create_subdirs($tdir, $sdir);

# In pre-2.13 versions of File::Safe, when calling rmtree() With 'safe'
# option, we never change permissions in an attempt to remove something.

# Only 0700 expected to fully succeed.
my $alt;

{
    $alt = $altered[7];
    my $removed_count = File::Path::rmtree($alt, { safe => 1 });
    Test::More::is($removed_count, 2,
        "rmtree (traditional) with 'safe' removed 2 items: file; directory $alt");
}

# 0000, 0100, 0200, 0300, 0400, 0500, 0600 expected to fail, but with
# different error messages.

for my $alt (@altered[0, 2, 4, 6]) {
    my $warning = '';
	$SIG{'__WARN__'} = sub { $warning = $_[0]; };
    my $removed_count = File::Path::rmtree($alt, { safe => 1 });
    Test::More::like($warning, qr/cannot chdir to child for $alt:/,
        "Got expected warning re inability to chdir to child $alt");
    Test::More::is($removed_count, 0,
        "rmtree (traditional) with 'safe' refrained from deleting: directory $alt");
}

{
    $alt = $altered[1];
    my $warning = '';
	$SIG{'__WARN__'} = sub { $warning = $_[0]; };
    my $removed_count = File::Path::rmtree($alt, { safe => 1 });
    Test::More::like($warning, qr/cannot opendir for $alt:/,
        "Got expected warning re inability to opendir $alt");
    Test::More::is($removed_count, 0,
        "rmtree (traditional) with 'safe' refrained from deleting: directory $alt");
}

{
    $alt = $altered[3];
    my $warning = '';
	$SIG{'__WARN__'} = sub { $warning = $_[0]; };
    my $removed_count = File::Path::rmtree($alt, { safe => 1 });
    Test::More::like($warning, qr/cannot remove directory for $alt:/,
        "Got expected warning re inability remove directory for $alt");
    Test::More::is($removed_count, 0,
        "rmtree (traditional) with 'safe' refrained from deleting: directory $alt");
}

{
    $alt = $altered[5];
    my $warning = '';
	$SIG{'__WARN__'} = sub { $warning = $_[0]; };
    my $removed_count = File::Path::rmtree($alt, { safe => 1 });
    Test::More::like($warning, qr/cannot restore permissions/,
        "Got expected warning re inability to restore permissions $alt");
    Test::More::is($removed_count, 0,
        "rmtree (traditional) with 'safe' refrained from deleting: directory $alt");
}

