# fprmtree-blead.t
use 5.12.0;
use warnings;
use File::Path 2.14 ();
use Test::More qw( no_plan );
use lib '.';
use CreateSubdirs ();

# Manually make some temporary directories and play with chmod.
# Try manually deleting them with rmtree() as revised and found in perl 5
# blead.

say "Perl version:       $]";
say "File::Path version: $File::Path::VERSION";
my $sdir = $$ . '_base';
say "subdir name:        $sdir";

my $tdir = '/tmp';
chdir $tdir or die "Unable to change to $tdir: $!";

my @altered = CreateSubdirs::create_subdirs($tdir, $sdir);

# We no longer expect File::Path::rmtree (unsafe) after 2.13 to remove everything
# 0100, 0300, 0400, 0500, 0600, 0700 expected to succeed
for my $alt (@altered[1,3..7]) {
    my $removed_count = File::Path::rmtree($alt);
    Test::More::is($removed_count, 2, "rmtree (NON-traditional) removed 2 items: file; directory $alt");
}

# 0000, 0200 expected to fail:  I have neither read nor execute permissions on
# these directories.
for my $alt (@altered[0,2]) {
    my $warning = '';
	$SIG{'__WARN__'} = sub { $warning = $_[0]; };
    my $removed_count = File::Path::rmtree($alt);
    Test::More::like($warning, qr/cannot chdir to child for $alt:/,
        "Got expected warning re inability to chdir to child $alt");
    Test::More::is($removed_count, 0, "rmtree (NON-traditional) failed: directory $alt");
}
