package CreateSubdirs;
# Underneath /tmp, create 0775 subdirectories, placing a plain-text file in each.
# Then, change perms on each to 0000, 0100, ... 0700
# Test appropriately.
use File::Path qw( mkpath );
use File::Spec;
use Fcntl qw(:mode);
use Test::More ();

sub create_subdirs {
    my ($tdir, $sdir, $no_create_file) = @_;

    chdir $tdir or die "Unable to change to $tdir: $!";
    my @created;
    @created = mkpath($sdir);
    Test::More::is(@created, 1, "created 1 subdirectory");
    my $p = File::Spec->catdir($tdir, $sdir);
    Test::More::ok(-d $p, "Directory $p exists");
    
    chdir $sdir or die "Unable to change to $sdir: $!";
    
    my @perms   = map { '0' . $_ . '00' } (0..7);
    my %p2s     = map { $_ => join('_' => 'foo', $$, $_) } @perms;
    my @subdirs = sort values(%p2s);
    
    @created = mkpath([@subdirs]);
    Test::More::is(scalar(@created), 8, "Created 8 subdirectories");
    for my $subdir (@subdirs) {
        my $p = File::Spec->catdir($tdir, $sdir, $subdir);
        my @perms = stat($p);
        my $mode = sprintf "%04o" => S_IMODE($perms[2]);
        Test::More::ok((-d $p) && ($mode eq '0775'), "Directory $p exists, starts life as 0775");
        create_file_within_subdir($p) unless $no_create_file;
    }
    
    # chmod the 3rd-level subdirs to 0000, 0100, ... 0700
    my @altered = ();
    for my $m (sort keys %p2s) {
        my $d = join('_' => 'foo', $$, $m);
        my $p = File::Spec->catdir($tdir, $sdir, $d);
        Test::More::is(chmod(oct($m), $p), 1, "chmod $p to $m");
        my @perms = stat($p);
        my $mode = sprintf "%04o" => S_IMODE($perms[2]);
        Test::More::cmp_ok($mode, 'eq', $m, "Directory $p changed to $m");
        push @altered, $p;
    }
    return @altered;
}

sub create_file_within_subdir {
    my $p = shift;
    my $fname = File::Spec->catfile($p, 'a');
    open my $F, '>', $fname or die "Unable to open $fname for writing: $!";
    print $F "a\n";
    close $F or die "Unable to close $fname after writing: $!";
    Test::More::ok(-f $fname, "Able to create file $fname");
}

1;
