# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl 01.t'

END {print "not ok 1\n" unless $loaded;}
use Test::Simple tests =>
130;
use lib ("./t");
use Mail::Digest::Tools qw( 
    process_new_digests 
    reply_to_digest_message
    repair_message_order
    consolidate_threads_single
    delete_deletables
);
use Test::_Test_MDT;
use List::Compare;
use File::Copy;
# use Data::Dumper;
use Cwd;
my $startdir = cwd(); # startdir is dir where Makefile.PL is located

$loaded = 1;
ok($loaded);                            # 1

use strict;
use warnings;

our (%digest_structure, %digest_output_format);
# variables imported from $data_file

my $data_file = 'samples/digest.data';
require $data_file;

# test of digests.data info and existence of key directories

ok(exists $digest_structure{'pbml'});   # 2
ok(exists $digest_output_format{'pbml'});# 3

my (%pbml_config_in, %pbml_config_out);

my ($k,$v);
while ( ($k, $v) = each %{$digest_structure{'pbml'}} ) {
    $pbml_config_in{$k} = $v;
}
while ( ($k, $v) = each %{$digest_output_format{'pbml'}} ) {
    $pbml_config_out{$k} = $v;
}

ok(  defined $pbml_config_in{'grep_formula'});# 4
ok(  defined $pbml_config_in{'pattern_target'});# 5
ok(  defined $pbml_config_in{'topics_intro'});# 6
ok(  defined $pbml_config_in{'post_topics_delimiter'});# 7
ok(  defined $pbml_config_in{'source_msg_delimiter'});# 8
ok(  defined $pbml_config_in{'topics_intro'});# 9
ok(  defined $pbml_config_in{'message_style_flag'});# 10
ok(  defined $pbml_config_in{'from_style_flag'});# 11
ok(! defined $pbml_config_in{'org_style_flag'});# 12
ok(! defined $pbml_config_in{'to_style_flag'});# 13
ok(! defined $pbml_config_in{'cc_style_flag'});# 14
ok(  defined $pbml_config_in{'subject_style_flag'});# 15
ok(  defined $pbml_config_in{'date_style_flag'});# 16
ok(! defined $pbml_config_in{'reply_to_style_flag'});# 17
ok(  defined $pbml_config_in{'MIME_cleanup_flag'});# 18

ok(  defined $pbml_config_out{'title'});# 19
ok(  defined $pbml_config_out{'dir_digest'});# 20
ok(  defined $pbml_config_out{'dir_threads'});# 21
ok(  defined $pbml_config_out{'dir_archive_top'});# 22
ok(  defined $pbml_config_out{'archived_today'});# 23
ok(  defined $pbml_config_out{'de_archived_today'});# 24
ok(  defined $pbml_config_out{'deleted_today'});# 25
ok(  defined $pbml_config_out{'digests_log'});# 26
ok(  defined $pbml_config_out{'digests_read'});# 27
ok(  defined $pbml_config_out{'todays_topics'});# 28
ok(  defined $pbml_config_out{'mimelog'});# 29
ok(  defined $pbml_config_out{'id_format'});# 30
ok(  defined $pbml_config_out{'output_id_format'});# 31
ok(  defined $pbml_config_out{'MIME_cleanup_log_flag'});# 32
ok(  defined $pbml_config_out{'thread_msg_delimiter'});# 33
ok(  defined $pbml_config_out{'archive_kill_trigger'});# 34
ok(  defined $pbml_config_out{'archive_kill_days'});# 35
ok(  defined $pbml_config_out{'digests_read_flag'});# 36
ok(  defined $pbml_config_out{'archive_config'});# 37

my ($digs, %log);
my ($pbml_digdir, $pbml_thrdir); 
$pbml_digdir = "$pbml_config_out{'dir_digest'}";
$pbml_thrdir = "$pbml_config_out{'dir_threads'}";
ok(-d $pbml_digdir);                    # 38
ok(-d $pbml_thrdir);                    # 39
 
########## Test of process_new_digests() on pbml ###########

# predict names and number of threads files to be created
# (by observation)

my (@pbml_tp);
if ($^O eq 'Unix' or $^O eq 'linux') {
    @pbml_tp = sort {lc($a) cmp lc($b)} (
        'grep over multiple lines.thr.txt',
        'How to $printHeader = \\&$fext::printHeader;.thr.txt',
        'HOW TO DO This.thr.txt',
        'how to get the current working directory.thr.txt',
        'newbie -> pattern matching.thr.txt',
        'One way to: $printHeader = \\&$fext::printHeader;.thr.txt',
        'Returning 2 file handles?.thr.txt',
        'Young and inexperienced.thr.txt',
    );
} elsif ($^O eq 'MSWin32') {
    @pbml_tp = sort {lc($a) cmp lc($b)} (
        'grep over multiple lines.thr.txt',
        'How to $printHeader = &$fextprintHeader;.thr.txt',
        'HOW TO DO This.thr.txt',
        'how to get the current working directory.thr.txt',
        'newbie - pattern matching.thr.txt',
        'One way to $printHeader = &$fextprintHeader;.thr.txt',
        'Returning 2 file handles.thr.txt',
        'Young and inexperienced.thr.txt',
    );
} else {
    die "Mail::Digest::Tools not available for operating system $^O: $!";
}

ok(@pbml_tp == 8, 'Predict 8 threads from pbml');# 40

# 0th element in value:  by observation, predict number of messages in 
# each thread file created
# 1st element in value:  by observation, predict number of paragraphs in each 
# message in each thread file created

my %pbml_tp = (
    $pbml_tp[0] => [ 3, [ 7, 9, 3 ] ],
    $pbml_tp[1] => [ 1, [ 7 ] ],
    $pbml_tp[2] => [ 4, [ 3, 4, 2, 18 ] ],
    $pbml_tp[3] => [ 2, [ 3, 6 ] ],
    $pbml_tp[4] => [ 3, [ 6, 5, 4 ] ],
    $pbml_tp[5] => [ 4, [ 5, 15, 5, 8 ] ],
    $pbml_tp[6] => [ 6, [ 3, 12, 5, 8, 4, 3 ] ],
    $pbml_tp[7] => [ 3, [ 5, 2, 2 ] ],
);

# predict message numbers found within each thread file created
# (by observation)

my %pbml_messp = ( 
    $pbml_tp[0] => [ qw|
      00001_0009
      00001_0010
      00001_0011
        | ],
    $pbml_tp[1] => [ qw|
      00001_0001
        | ],
    $pbml_tp[2] => [ qw|
      00002_0005
      00002_0006
      00002_0008
      00003_0004
        | ],
    $pbml_tp[3] => [ qw|
      00002_0007
      00003_0001
        | ],
    $pbml_tp[4] => [ qw|
      00002_0001
      00002_0002
      00002_0003
        | ],
    $pbml_tp[5] => [ qw|
      00001_0002
      00001_0003
      00001_0004
      00001_0006
        | ],
    $pbml_tp[6] => [ qw|
      00001_0005
      00001_0007
      00001_0008
      00002_0004
      00003_0002
      00003_0007
        | ],
    $pbml_tp[7] => [ qw|
      00003_0003
      00003_0005
      00003_0006
        | ],
);
# determine number of digests needing processing

opendir DIG, $pbml_digdir or die "Couldn't open directory $pbml_digdir: $!";
$log{'digs'} = scalar(
    grep { /$pbml_config_in{'grep_formula'}/ } readdir DIG);
closedir DIG or die "Couldn't close directory $pbml_digdir: $!";
ok($log{'digs'} == 3, '3 pbml digests found before processing'); # 41

# verify log files are empty or do not yet exist

my $dl  = $pbml_config_out{'digests_log'};
my $dr  = $pbml_config_out{'digests_read'};
my $drf = $pbml_config_out{'digests_read_flag'};
my $tt  = $pbml_config_out{'todays_topics'};

$log{'log'}{'size'}[0]    = (-f $dl) ? (-s $dl) : 0;
$log{'read'}{'size'}[0]   = ( (-f $dr) and $drf) ? (-s $dr) : undef;
$log{'topics'}{'size'}[0] = (-f $tt) ? (-s $tt) : 0;

$log{'log'}{'records'}[0]    = (-f $dl) ? count_records($dl, "\n") : 0;
$log{'read'}{'records'}[0]   = ((-f $dr) and $drf) ? count_records($dr, "\n\n") : 0;
$log{'topics'}{'records'}[0] = (-f $tt) ? count_records($tt, "\n\n") : 0;

ok($log{'log'}{'records'}[0]    == 0, 'digests_log currently empty'); # 42
ok($log{'read'}{'records'}[0]   == 0, 'digests_read currently empty'); # 43
ok($log{'topics'}{'records'}[0] == 0, 'todays_topics currently empty'); # 44

# run Mail::Digest::tools function

process_new_digests(\%pbml_config_in, \%pbml_config_out);

# test whether log files have grown in size

$log{'log'}{'size'}[1]    = (-s $dl);
$log{'read'}{'size'}[1]   = ( (-f $dr) and $drf) ? (-s $dr) : undef;
$log{'topics'}{'size'}[1] = (-s $tt);

ok($log{'log'}{'size'}[1] > $log{'log'}{'size'}[0], # 45
    'digests_log for pbml has grown');
ok(                                     # 46
   ( 
    (
     ! defined $log{'read'}{'size'}[0] 
     and 
     ! defined $log{'read'}{'size'}[1]
    )
    or
    ( 
     (
      defined $log{'read'}{'size'}[0] 
      and 
      defined $log{'read'}{'size'}[1]
     )
     and
     (
      $log{'read'}{'size'}[1] > $log{'read'}{'size'}[0]
     )
    )
   ), 'digests_read for pbml has grown'
);
ok($log{'topics'}{'size'}[1] > $log{'topics'}{'size'}[0],# 47
    'todays_topics for pbml has grown');

# test whether log files have grown by correct number of records

$log{'log'}{'records'}[1]    = (-f $dl) ? count_records($dl, "\n") : 0;
$log{'read'}{'records'}[1]   = ((-f $dr) and $drf) ? count_records($dr, "\n\n") : 0;
$log{'topics'}{'records'}[1] = (-f $tt) ? count_records($tt, "\n\n") : 0;

ok($log{'log'}{'records'}[0] + $log{'digs'} == # 48
    $log{'log'}{'records'}[1], 
    'digests_log grew by predicted number of records');
ok(                                     # 49
   ( 
    (
     ! defined $log{'read'}{'size'}[0] 
     and 
     ! defined $log{'read'}{'size'}[1]
    )
    or
    ( 
     (
      defined $log{'read'}{'size'}[0] 
      and 
      defined $log{'read'}{'size'}[1]
     )
     and
     (
      $log{'read'}{'records'}[0] + $log{'digs'} + 1 == 
      $log{'read'}{'records'}[1]
     )
    )
   ), 'digests_read grew by predicted number of records'
);
ok($log{'topics'}{'records'}[0] + $log{'digs'} == # 50
    $log{'topics'}{'records'}[1], 
    'todays_topics grew by predicted number of records');

# test whether correct number of threads files have been created
 
chdir $pbml_thrdir or die "Couldn't change to pbml threads dir: $!";
opendir DIR, $pbml_thrdir or die "Couldn't open dir: $!";
my @pbml_tc = sort {lc($a) cmp lc($b)} grep {/\.thr\.txt$/} readdir DIR;
closedir DIR or die "Couldn't close dir: $!";

ok(@pbml_tc == 8, '8 threads created from pbml');# 51

# test whether thread files have names predicted

ok($pbml_tp[0] eq $pbml_tc[0], 'grep over multiple lines.thr.txt');# 52
ok($pbml_tp[1] eq $pbml_tc[1], 'How to $printHeader = \\&$fext::printHeader;.thr.txt');# 53
ok($pbml_tp[2] eq $pbml_tc[2], 'HOW TO DO This.thr.txt');# 54
ok($pbml_tp[3] eq $pbml_tc[3], 'how to get the current working directory.thr.txt');# 55
ok($pbml_tp[4] eq $pbml_tc[4], 'newbie -> pattern matching.thr.txt');# 56
ok($pbml_tp[5] eq $pbml_tc[5], 'One way to: $printHeader = \\&$fext::printHeader;.thr.txt');# 57
ok($pbml_tp[6] eq $pbml_tc[6], 'Returning 2 file handles?.thr.txt');# 58
ok($pbml_tp[7] eq $pbml_tc[7], 'Young and inexperienced.thr.txt');# 59


my $lcpb = List::Compare->new(\@pbml_tp, \@pbml_tc);
ok( ($lcpb->get_intersection()) == @pbml_tp, # 60
    'all pbml threads predicted have been created');

# test whether thread files have predicted message count
my $tmd = $pbml_config_out{'thread_msg_delimiter'};
ok(${$pbml_tp{$pbml_tp[0]}}[0] == verify_message_count(# 61
              $pbml_tc[0], $tmd));
ok(${$pbml_tp{$pbml_tp[1]}}[0] == verify_message_count(# 62
              $pbml_tc[1], $tmd));
ok(${$pbml_tp{$pbml_tp[2]}}[0] == verify_message_count(# 63
              $pbml_tc[2], $tmd));
ok(${$pbml_tp{$pbml_tp[3]}}[0] == verify_message_count(# 64
              $pbml_tc[3], $tmd));
ok(${$pbml_tp{$pbml_tp[4]}}[0] == verify_message_count(# 65
              $pbml_tc[4], $tmd));
ok(${$pbml_tp{$pbml_tp[5]}}[0] == verify_message_count(# 66
              $pbml_tc[5], $tmd));
ok(${$pbml_tp{$pbml_tp[6]}}[0] == verify_message_count(# 67
              $pbml_tc[6], $tmd));
ok(${$pbml_tp{$pbml_tp[7]}}[0] == verify_message_count(# 68
              $pbml_tc[7], $tmd));

# test whether messages in thread files are correct and appear in 
# predicted sequence

ok( compare_arrays(\@{$pbml_messp{$pbml_tp[0]}}, # 69
      get_message_numbers_created($pbml_tc[0], $tmd) ) );
ok( compare_arrays(\@{$pbml_messp{$pbml_tp[1]}}, # 70
      get_message_numbers_created($pbml_tc[1], $tmd) ) );
ok( compare_arrays(\@{$pbml_messp{$pbml_tp[2]}}, # 71
      get_message_numbers_created($pbml_tc[2], $tmd) ) );
ok( compare_arrays(\@{$pbml_messp{$pbml_tp[3]}}, # 72
      get_message_numbers_created($pbml_tc[3], $tmd) ) );
ok( compare_arrays(\@{$pbml_messp{$pbml_tp[4]}}, # 73
      get_message_numbers_created($pbml_tc[4], $tmd) ) );
ok( compare_arrays(\@{$pbml_messp{$pbml_tp[5]}}, # 74
      get_message_numbers_created($pbml_tc[5], $tmd) ) );
ok( compare_arrays(\@{$pbml_messp{$pbml_tp[6]}}, # 75
      get_message_numbers_created($pbml_tc[6], $tmd) ) );
ok( compare_arrays(\@{$pbml_messp{$pbml_tp[7]}}, # 76
      get_message_numbers_created($pbml_tc[7], $tmd) ) );

# test whether messages in thread files have predicted number of paragraphs

ok( compare_arrays(${$pbml_tp{$pbml_tp[0]}}[1], # 77
          get_paragraph_count($pbml_tp[0], $tmd) ) );
ok( compare_arrays(${$pbml_tp{$pbml_tp[1]}}[1], # 78
          get_paragraph_count($pbml_tp[1], $tmd) ) );
ok( compare_arrays(${$pbml_tp{$pbml_tp[2]}}[1], # 79
          get_paragraph_count($pbml_tp[2], $tmd) ) );
ok( compare_arrays(${$pbml_tp{$pbml_tp[3]}}[1], # 80
          get_paragraph_count($pbml_tp[3], $tmd) ) );
ok( compare_arrays(${$pbml_tp{$pbml_tp[4]}}[1], # 81
          get_paragraph_count($pbml_tp[4], $tmd) ) );
ok( compare_arrays(${$pbml_tp{$pbml_tp[5]}}[1], # 82
          get_paragraph_count($pbml_tp[5], $tmd) ) );
ok( compare_arrays(${$pbml_tp{$pbml_tp[6]}}[1], # 83
          get_paragraph_count($pbml_tp[6], $tmd) ) );
ok( compare_arrays(${$pbml_tp{$pbml_tp[7]}}[1], # 84
          get_paragraph_count($pbml_tp[7], $tmd) ) );

chdir $startdir or die "Couldn't change back to $startdir: $!";

# run Mail::Digest::Tools function reply_to_digest_message()

my $digest_number = 3;
my $digest_entry = 3;
my $directory_for_reply = "$startdir/t/samples/pbml/Threads";

my $full_reply_file = reply_to_digest_message(
    \%pbml_config_in, 
    \%pbml_config_out, 
    $digest_number, 
    $digest_entry, 
    $directory_for_reply,
);

# make sure appropriately named reply file was created and that it has the 
# correct number of paragraphs

my $rtsf = defined $pbml_config_in{'reply_to_style_flag'} ? 1 : 0;
my $reply_file_predicted = "$directory_for_reply/Young and inexperienced.reply.txt";
my $total_paragraphs_predicted = 3 + $rtsf;
my $text_paragraphs_replied_to_predicted = 4;
ok(-f $reply_file_predicted);           # 85
ok($total_paragraphs_predicted ==       # 86
    get_paragraph_count_reply($reply_file_predicted) );
ok($text_paragraphs_replied_to_predicted == # 87
    get_paragraphs_replied_to_count($reply_file_predicted, $rtsf) );

#######################################################################
# below:  tests of repair_message_order()

# problem for testing:  repair_message_order() overwrites its files
# so I'll have to store the wrongly-ordered files somewhere, make predictions 
# as to the outcome, then move the files into the directory where the function 
# will actually be called
# then, examine those new files to see if they match the predictions

my ($need_fix_dir, @need_fix_files, $dir_threads_orig, $repair_dir);
my (@pbml_fp, %pbml_fp, %pbml_fmessp);
my (@pbml_fc);

$need_fix_dir = "$startdir/t/needfix/pbml";
chdir $need_fix_dir or die "Couldn't change to $need_fix_dir: $!";
opendir DIR, $need_fix_dir or die "Couldn't open $need_fix_dir: $!";
@need_fix_files = grep {/\.fix\.thr\.txt$/} readdir DIR;
closedir DIR or die "Couldn't close $need_fix_dir: $!";
foreach my $nff (@need_fix_files) {
    copy $nff, "$startdir/t/repair/pbml/$nff" or die "Couldn't copy fix file: $!";
}
chdir $startdir or die "Couldn't change back to $startdir: $!";
$dir_threads_orig = $pbml_config_out{'dir_threads'};
$pbml_config_out{'dir_threads'} = "$startdir/t/repair/pbml";

# make predictions

foreach my $orig (@pbml_tp) {
	if ($orig =~ /(.*)(\.thr\.txt)$/) {
		push(@pbml_fp, "$1.fix$2");
	} else {
		die "Couldn't predict name of fixed file: $!";
	}
}

for (my $k=0; $k <= $#pbml_tp; $k++) {
	$pbml_fp{$pbml_fp[$k]}     = $pbml_tp{$pbml_tp[$k]};
	$pbml_fmessp{$pbml_fp[$k]} = $pbml_messp{$pbml_tp[$k]};
}

# run Mail::Digest::Tools function repair_message_order()

repair_message_order (
    \%pbml_config_in, 
    \%pbml_config_out,
    { year => 2000, month => 01, day => 01 },
);
 
# test whether correct number of threads files have been fixed

$repair_dir = "$startdir/t/repair/pbml";
 
chdir $repair_dir or die "Couldn't change to pbml threads dir: $!";
opendir DIR, $repair_dir or die "Couldn't open dir: $!";
@pbml_fc = sort {lc($a) cmp lc($b)} grep {/\.fix\.thr\.txt$/} readdir DIR;
closedir DIR or die "Couldn't close dir: $!";

ok(@pbml_fc == 8, '8 threads fixed from pbml');# 88

# test whether fixed files have names predicted

ok($pbml_fp[0] eq $pbml_fc[0], 'grep over multiple lines.fix.thr.txt');# 89
ok($pbml_fp[1] eq $pbml_fc[1], 'How to $printHeader = \\&$fext::printHeader;.fix.thr.txt');# 90
ok($pbml_fp[2] eq $pbml_fc[2], 'HOW TO DO This.fix.thr.txt');# 91
ok($pbml_fp[3] eq $pbml_fc[3], 'how to get the current working directory.fix.thr.txt');# 92
ok($pbml_fp[4] eq $pbml_fc[4], 'newbie -> pattern matching.fix.thr.txt');# 93
ok($pbml_fp[5] eq $pbml_fc[5], 'One way to: $printHeader = \\&$fext::printHeader;.fix.thr.txt');# 94
ok($pbml_fp[6] eq $pbml_fc[6], 'Returning 2 file handles?.fix.thr.txt');# 95
ok($pbml_fp[7] eq $pbml_fc[7], 'Young and inexperienced.fix.thr.txt');# 96


my $lcfpb = List::Compare->new(\@pbml_fp, \@pbml_fc);
ok( ($lcfpb->get_intersection()) == @pbml_fp, # 97
    'all pbml fixed threads predicted have been created');

# test whether thread files have predicted message count
ok(${$pbml_fp{$pbml_fp[0]}}[0] == verify_message_count(# 98
              $pbml_fc[0], $tmd));
ok(${$pbml_fp{$pbml_fp[1]}}[0] == verify_message_count(# 99
              $pbml_fc[1], $tmd));
ok(${$pbml_fp{$pbml_fp[2]}}[0] == verify_message_count(# 100
              $pbml_fc[2], $tmd));
ok(${$pbml_fp{$pbml_fp[3]}}[0] == verify_message_count(# 101
              $pbml_fc[3], $tmd));
ok(${$pbml_fp{$pbml_fp[4]}}[0] == verify_message_count(# 102
              $pbml_fc[4], $tmd));
ok(${$pbml_fp{$pbml_fp[5]}}[0] == verify_message_count(# 103
              $pbml_fc[5], $tmd));
ok(${$pbml_fp{$pbml_fp[6]}}[0] == verify_message_count(# 104
              $pbml_fc[6], $tmd));
ok(${$pbml_fp{$pbml_fp[7]}}[0] == verify_message_count(# 105
              $pbml_fc[7], $tmd));

# test whether messages in thread files are correct and appear in 
# predicted sequence

ok( compare_arrays(\@{$pbml_fmessp{$pbml_fp[0]}}, # 106
      get_message_numbers_created($pbml_fc[0], $tmd) ) );
ok( compare_arrays(\@{$pbml_fmessp{$pbml_fp[1]}}, # 107
      get_message_numbers_created($pbml_fc[1], $tmd) ) );
ok( compare_arrays(\@{$pbml_fmessp{$pbml_fp[2]}}, # 108
      get_message_numbers_created($pbml_fc[2], $tmd) ) );
ok( compare_arrays(\@{$pbml_fmessp{$pbml_fp[3]}}, # 109
      get_message_numbers_created($pbml_fc[3], $tmd) ) );
ok( compare_arrays(\@{$pbml_fmessp{$pbml_fp[4]}}, # 110
      get_message_numbers_created($pbml_fc[4], $tmd) ) );
ok( compare_arrays(\@{$pbml_fmessp{$pbml_fp[5]}}, # 111
      get_message_numbers_created($pbml_fc[5], $tmd) ) );
ok( compare_arrays(\@{$pbml_fmessp{$pbml_fp[6]}}, # 112
      get_message_numbers_created($pbml_fc[6], $tmd) ) );
ok( compare_arrays(\@{$pbml_fmessp{$pbml_fp[7]}}, # 113
      get_message_numbers_created($pbml_fc[7], $tmd) ) );

# test whether messages in thread files have predicted number of paragraphs

ok( compare_arrays(${$pbml_fp{$pbml_fp[0]}}[1], # 114
          get_paragraph_count($pbml_fp[0], $tmd) ) );
ok( compare_arrays(${$pbml_fp{$pbml_fp[1]}}[1], # 115
          get_paragraph_count($pbml_fp[1], $tmd) ) );
ok( compare_arrays(${$pbml_fp{$pbml_fp[2]}}[1], # 116
          get_paragraph_count($pbml_fp[2], $tmd) ) );
ok( compare_arrays(${$pbml_fp{$pbml_fp[3]}}[1], # 117
          get_paragraph_count($pbml_fp[3], $tmd) ) );
ok( compare_arrays(${$pbml_fp{$pbml_fp[4]}}[1], # 118
          get_paragraph_count($pbml_fp[4], $tmd) ) );
ok( compare_arrays(${$pbml_fp{$pbml_fp[5]}}[1], # 119
          get_paragraph_count($pbml_fp[5], $tmd) ) );
ok( compare_arrays(${$pbml_fp{$pbml_fp[6]}}[1], # 120
          get_paragraph_count($pbml_fp[6], $tmd) ) );
ok( compare_arrays(${$pbml_fp{$pbml_fp[7]}}[1], # 121
          get_paragraph_count($pbml_fp[7], $tmd) ) );

chdir $startdir or die "Couldn't change back to $startdir: $!";

#######################################################################
# below:  tests of consolidate_threads_single()

my ($consol_in_dir, $consol_out_dir, @consol_test, $consol_predict, 
    @consol_tp, @consol_messp, @consol_tc, @consol_messc);

$consol_in_dir  = "$startdir/t/consol/in/pbml";
$consol_out_dir = "$startdir/t/consol/out/pbml";
$pbml_config_out{'dir_threads'} = $consol_out_dir;
@consol_test = (
        'grep over multiple lines.thr.txt',
        'grep over multiple lines thank you.thr.txt',
);

$consol_predict = 'grep over multiple lines.thr.txt';

chdir $consol_in_dir or die "Couldn't change to $consol_in_dir: $!";
foreach my $orig (@consol_test) {
	copy $orig, "$consol_out_dir/$orig"
		or die "Could not copy $orig for test of consolidation: $!";
}

@consol_tp    = ( 3, [ 7, 9, 3 ] );
@consol_messp = ( qw|
      00001_0009
      00001_0010
      00001_0011
|);

# run Mail::Digest::Tools function consolidate_threads_single()

consolidate_threads_single(
	\%pbml_config_in,
	\%pbml_config_out,
	\@consol_test
);

chdir $consol_out_dir or die "Couldn't change to pbml threads dir: $!";
opendir DIR, $consol_out_dir or die "Couldn't open dir: $!";
@consol_tc = sort {lc($a) cmp lc($b)} grep {/\.thr\.txt$/} readdir DIR;
closedir DIR or die "Couldn't close dir: $!";

# test whether correct number of threads files have been fixed

ok(@consol_tc == 1, '1 thread consolidated from pbml');# 122

# test whether consolidated file has been correctly named

ok($consol_predict eq $consol_tc[0], 'grep over multiple lines.thr.txt');# 123

# test whether consolidated file has predicted message count

ok($consol_tp[0] == verify_message_count(# 124
              $consol_tc[0], $tmd));

# test whether messages in consolidated file have predicted number of paragraphs

ok( compare_arrays($consol_tp[1],       # 125
          get_paragraph_count($consol_tc[0], $tmd) ) );

#######################################################################
# below:  tests of delete_deletables()

my (@del_predicted, @del_created, @del_verified); 
foreach my $orig (@consol_test) {
	push(@del_predicted, $orig . '.DELETABLE');
};
@del_predicted = sort {lc($a) cmp lc($b)} @del_predicted;

opendir DIR, $consol_out_dir or die "Couldn't open dir: $!";
@del_created = sort {lc($a) cmp lc($b)} 
               map {"$consol_out_dir/$_"} 
               grep {/\.thr\.txt\.DELETABLE$/} 
               readdir DIR;
closedir DIR or die "Couldn't close dir: $!";

#my $dump = "$startdir/t/dump";
#open DUMP, ">$dump" or die "Couldn't open $dump for writing: $!";
#print DUMP Dumper(\@del_predicted, \@del_created);
#close DUMP or die "Couldn't close $dump after writing: $!";

# test whether correct number of deletable files were created

ok(@del_predicted == @del_created, 'correct number of deletables');# 126
ok(@del_created == 2, 'correct number of deletables');# 127

# test whether deletable files were correctly named

ok($del_predicted[0] eq $del_created[0]);# 128
ok($del_predicted[1] eq $del_created[1]);# 129

# run Mail::Digest::Tools function delete_deletables()

delete_deletables(\%pbml_config_out);

# verify that deletables have been deleted

opendir DIR, $consol_out_dir or die "Couldn't open dir: $!";
@del_verified = grep {/\.DELETABLE$/} readdir DIR;
closedir DIR or die "Couldn't close dir: $!";

ok(@del_verified == 0, 'no deletable files left');# 130

######################################################################
# restore original conditions

chdir $startdir or die "Couldn't change back to $startdir: $!";
$pbml_config_out{'dir_threads'} = $dir_threads_orig;

