.\" -*- mode: troff; coding: utf-8 -*-
.\" Automatically generated by Pod::Man v6.0.2 (Pod::Simple 3.45)
.\"
.\" Standard preamble:
.\" ========================================================================
.de Sp \" Vertical space (when we can't use .PP)
.if t .sp .5v
.if n .sp
..
.de Vb \" Begin verbatim text
.ft CW
.nf
.ne \\$1
..
.de Ve \" End verbatim text
.ft R
.fi
..
.\" \*(C` and \*(C' are quotes in nroff, nothing in troff, for use with C<>.
.ie n \{\
.    ds C` ""
.    ds C' ""
'br\}
.el\{\
.    ds C`
.    ds C'
'br\}
.\"
.\" Escape single quotes in literal strings from groff's Unicode transform.
.ie \n(.g .ds Aq \(aq
.el       .ds Aq '
.\"
.\" If the F register is >0, we'll generate index entries on stderr for
.\" titles (.TH), headers (.SH), subsections (.SS), items (.Ip), and index
.\" entries marked with X<> in POD.  Of course, you'll have to process the
.\" output yourself in some meaningful fashion.
.\"
.\" Avoid warning from groff about undefined register 'F'.
.de IX
..
.nr rF 0
.if \n(.g .if rF .nr rF 1
.if (\n(rF:(\n(.g==0)) \{\
.    if \nF \{\
.        de IX
.        tm Index:\\$1\t\\n%\t"\\$2"
..
.        if !\nF==2 \{\
.            nr % 0
.            nr F 2
.        \}
.    \}
.\}
.rr rF
.\"
.\" Required to disable full justification in groff 1.23.0.
.if n .ds AD l
.\" ========================================================================
.\"
.IX Title "STDIN 1"
.TH STDIN 1 2025-11-16 "perl v5.42.0" "User Contributed Perl Documentation"
.\" For nroff, turn off justification.  Always turn off hyphenation; it makes
.\" way too many mistakes in technical documents.
.if n .ad l
.nh
.SH NAME
shasum \- Print or Check SHA Checksums
.SH SYNOPSIS
.IX Header "SYNOPSIS"
.Vb 3
\& Usage: shasum [OPTION]... [FILE]...
\& Print or check SHA checksums.
\& With no FILE, or when FILE is \-, read standard input.
\&
\&   \-a, \-\-algorithm   1 (default), 224, 256, 384, 512, 512224, 512256
\&   \-b, \-\-binary      read in binary mode
\&   \-c, \-\-check       read SHA sums from the FILEs and check them
\&       \-\-tag         create a BSD\-style checksum
\&   \-t, \-\-text        read in text mode (default)
\&   \-U, \-\-UNIVERSAL   read in Universal Newlines mode
\&                         produces same digest on Windows/Unix/Mac
\&   \-0, \-\-01          read in BITS mode
\&                         ASCII \*(Aq0\*(Aq interpreted as 0\-bit,
\&                         ASCII \*(Aq1\*(Aq interpreted as 1\-bit,
\&                         all other characters ignored
\&
\& The following five options are useful only when verifying checksums:
\&       \-\-ignore\-missing  don\*(Aqt fail or report status for missing files
\&   \-q, \-\-quiet           don\*(Aqt print OK for each successfully verified file
\&   \-s, \-\-status          don\*(Aqt output anything, status code shows success
\&       \-\-strict          exit non\-zero for improperly formatted checksum lines
\&   \-w, \-\-warn            warn about improperly formatted checksum lines
\&
\&   \-h, \-\-help        display this help and exit
\&   \-v, \-\-version     output version information and exit
\&
\& When verifying SHA\-512/224 or SHA\-512/256 checksums, indicate the
\& algorithm explicitly using the \-a option, e.g.
\&
\&   shasum \-a 512224 \-c checksumfile
\&
\& The sums are computed as described in FIPS PUB 180\-4.  When checking,
\& the input should be a former output of this program.  The default
\& mode is to print a line with checksum, a character indicating type
\& (\`*\*(Aq for binary, \` \*(Aq for text, \`U\*(Aq for UNIVERSAL, \`^\*(Aq for BITS),
\& and name for each FILE.  The line starts with a \`\e\*(Aq character if the
\& FILE name contains either newlines or backslashes, which are then
\& replaced by the two\-character sequences \`\en\*(Aq and \`\e\e\*(Aq respectively.
\&
\& Report shasum bugs to mshelor@cpan.org
.Ve
.SH DESCRIPTION
.IX Header "DESCRIPTION"
Running \fIshasum\fR is often the quickest way to compute SHA message
digests.  The user simply feeds data to the script through files or
standard input, and then collects the results from standard output.
.PP
The following command shows how to compute digests for typical inputs
such as the NIST test vector "abc":
.PP
.Vb 1
\&        perl \-e "print qq(abc)" | shasum
.Ve
.PP
Or, if you want to use SHA\-256 instead of the default SHA\-1, simply say:
.PP
.Vb 1
\&        perl \-e "print qq(abc)" | shasum \-a 256
.Ve
.PP
Since \fIshasum\fR mimics the behavior of the combined GNU \fIsha1sum\fR,
\&\fIsha224sum\fR, \fIsha256sum\fR, \fIsha384sum\fR, and \fIsha512sum\fR programs,
you can install this script as a convenient drop\-in replacement.
.PP
Unlike the GNU programs, \fIshasum\fR encompasses the full SHA standard by
allowing partial\-byte inputs.  This is accomplished through the BITS
option (\fI\-0\fR).  The following example computes the SHA\-224 digest of
the 7\-bit message \fI0001100\fR:
.PP
.Vb 1
\&        perl \-e "print qq(0001100)" | shasum \-0 \-a 224
.Ve
.SH AUTHOR
.IX Header "AUTHOR"
Copyright (C) 2003\-2023 Mark Shelor <mshelor@cpan.org>.
.SH "SEE ALSO"
.IX Header "SEE ALSO"
\&\fIshasum\fR is implemented using the Perl module Digest::SHA.
