#!perl
# test apparatus for Text::Template module

use strict;
use warnings;
use Text::Template;
use lib ("./t/testlib");
use Test::More tests => 5;


die "This is the test program for Text::Template version 1.45.
You are using version $Text::Template::VERSION instead.
That does not make sense.\n
Aborting"
  unless $Text::Template::VERSION == 1.45;

# (1) basic error delivery
{ my $r = Text::Template->new(TYPE => 'string',
                              SOURCE => '{1/0}',
                             )->fill_in();
  is ($r,
          q{Program fragment delivered error ``Illegal division by zero at template line 1.''},
          "Basic error delivery.")
      || print " # $r\n";
}

# (2) BROKEN sub called in ->new?
{ my $r = Text::Template->new(TYPE => 'string',
                              SOURCE => '{1/0}',
                              BROKEN => sub {'---'},
                             )->fill_in();
  is ($r, q{---}, "BROKEN sub called in ->new?")
      ||
      print " # $r\n";
}

# (3) BROKEN sub called in ->fill_in?
{ my $r = Text::Template->new(TYPE => 'string',
                              SOURCE => '{1/0}',
                             )->fill_in(BROKEN => sub {'---'});
  is ($r, q{---}, "BROKEN sub called in ->fill_in?")
      ||
      print "# $r\n";
}

# (4) BROKEN sub passed correct args when called in ->new?
{ my $r = Text::Template->new(TYPE => 'string',
                              SOURCE => '{1/0}',
                              BROKEN => sub { my %a = @_;
                                qq{$a{lineno},$a{error},$a{text}}
                              },
                             )->fill_in();
  is ($r, qq{1,Illegal division by zero at template line 1.\n,1/0},
          "BROKEN sub passed correct args when called in ->new?")
      ||
      print "# $r\n";
}

# (5) BROKEN sub passed correct args when called in ->fill_in?
{ my $r = Text::Template->new(TYPE => 'string',
                              SOURCE => '{1/0}',
                             )->fill_in(BROKEN =>
                                        sub { my %a = @_;
                                              qq{$a{lineno},$a{error},$a{text}}
                                            });
  is ($r, qq{1,Illegal division by zero at template line 1.\n,1/0},
          "BROKEN sub passed correct args when called in ->fill_in?")
      ||
      print "# $r\n";
}

