#!perl -T
# Tests for taint-mode features

use strict;
use warnings;
use Text::Template;
use lib ("./t/testlib");
use Test::More tests => 21;
use File::Temp 0.14;

die "This is the test program for Text::Template version 1.45.
You are using version $Text::Template::VERSION instead.
That does not make sense.\n
Aborting"
  unless $Text::Template::VERSION == 1.45;

my $r = int(rand(10000));
my $TF = new File::Temp();
my $tempfile = $TF->filename;

# makes its arguments tainted
sub taint {
  for (@_) {
    $_ .= substr($0,0,0);       # LOD
  }
}

ok (1); # presumably a control case

my $template = 'The value of $n is {$n}.';

open $TF, "> $tempfile" or die "Couldn't write temporary file $tempfile: $!";
print $TF $template, "\n";
close $TF or die "Couldn't finish temporary file $tempfile: $!";

sub should_fail {
  my $obj = Text::Template->new(@_);
  eval {$obj->fill_in()};
  if (ok($@)) {
    print " # $@\n";
  } else {
    print " # (didn't fail)\n";
  }
}

sub should_work {
  my $obj = Text::Template->new(@_);
  eval {$obj->fill_in()};
  if (ok(! $@)) {
  1;
  } else {
      print " # $@\n";
  }
}

sub should_be_tainted {
    ok (! Text::Template::_is_clean($_[0]));
}

sub should_be_clean {
    ok(Text::Template::_is_clean($_[0]));
}

# Tainted filename should die with and without UNTAINT option
# untainted filename should die without UNTAINT option
# filehandle should die without UNTAINT option
# string and array with tainted data should die either way

# (2)-(7)
my $tfile = $tempfile;
taint($tfile);
should_be_tainted($tfile);
should_be_clean($tempfile);
should_fail TYPE => 'file', SOURCE => $tfile;
should_fail TYPE => 'file', SOURCE => $tfile, UNTAINT => 1;
should_fail TYPE => 'file', SOURCE => $tempfile;
should_work TYPE => 'file', SOURCE => $tempfile, UNTAINT => 1;

# (8-9)
open $TF, "< $tempfile" or die "Couldn't open $tempfile for reading: $!; aborting";
should_fail TYPE => 'filehandle', SOURCE => $TF;
close $TF;
open $TF, "< $tempfile" or die "Couldn't open $tempfile for reading: $!; aborting";
should_work TYPE => 'filehandle', SOURCE => $TF, UNTAINT => 1;
close $TF;

# (10-15)
my $ttemplate = $template;
taint($ttemplate);
should_be_tainted($ttemplate);
should_be_clean($template);
should_fail TYPE => 'string', SOURCE => $ttemplate;
should_fail TYPE => 'string', SOURCE => $ttemplate, UNTAINT => 1;
should_work TYPE => 'string', SOURCE => $template;
should_work TYPE => 'string', SOURCE => $template, UNTAINT => 1;

# (16-19)
my $array = [ $template ];
my $tarray = [ $ttemplate ];
should_fail TYPE => 'array', SOURCE => $tarray;
should_fail TYPE => 'array', SOURCE => $tarray, UNTAINT => 1;
should_work TYPE => 'array', SOURCE => $array;
should_work TYPE => 'array', SOURCE => $array, UNTAINT => 1;

# (20-21) Test _unconditionally_untaint utility function
Text::Template::_unconditionally_untaint($ttemplate);
should_be_clean($ttemplate);
Text::Template::_unconditionally_untaint($tfile);
should_be_clean($tfile);


