#!perl
#
# Tests for user-specified delimiter functions
# These tests first appeared in version 1.20.

use strict;
use warnings;
use Text::Template;
use lib ("./t/testlib");
use Test::More tests => 18;

die "This is the test program for Text::Template version 1.45.
You are using version $Text::Template::VERSION instead.
That does not make sense.\n
Aborting"
  unless $Text::Template::VERSION == 1.45;

# (1) Try a simple delimiter: <<..>>
# First with the delimiters specified at object creation time
our $V;
$V = $V = 119;
my $template = q{The value of $V is <<$V>>.};
my $result = q{The value of $V is 119.};
my $template1 = Text::Template->new(TYPE => 'STRING',
				 SOURCE => $template,
				 DELIMITERS => ['<<', '>>']
				)
  or die "Couldn't construct template object: $Text::Template::ERROR; aborting";
my $text = $template1->fill_in();
is ($text, $result, "Try a simple delimiter: <<..>>");

# (2) Now with delimiter choice deferred until fill-in time.
$template1 = Text::Template->new(TYPE => 'STRING', SOURCE => $template);
$text = $template1->fill_in(DELIMITERS => ['<<', '>>']);
is ($text, $result,
        "Now with delimiter choice deferred until fill-in time.");

# (3) Now we'll try using regex metacharacters
# First with the delimiters specified at object creation time
$template = q{The value of $V is [$V].};
$template1 = Text::Template->new(TYPE => 'STRING',
				 SOURCE => $template,
				 DELIMITERS => ['[', ']']
				)
  or die "Couldn't construct template object: $Text::Template::ERROR; aborting";
$text = $template1->fill_in();
print "Now we'll try using regex metacharacters\n";
is ($text, $result,
        "First with the delimiters specified at object creation time");

# (4) Now with delimiter choice deferred until fill-in time.
$template1 = Text::Template->new(TYPE => 'STRING', SOURCE => $template);
$text = $template1->fill_in(DELIMITERS => ['[', ']']);
is ($text, $result,
"Now with delimiter choice deferred until fill-in time.");


# (5-18) Make sure \ is working properly
# (That is to say, it is ignored.)
# These tests are similar to those in 01-basic.t.
my @tests = ('{""}' => '',	# (5)

	     # Backslashes don't matter
	     '{"}"}' => undef,
	     '{"\\}"}' => undef,	# One backslash
	     '{"\\\\}"}' => undef, # Two backslashes
	     '{"\\\\\\}"}' => undef, # Three backslashes
	     '{"\\\\\\\\}"}' => undef, # Four backslashes (10)
	     '{"\\\\\\\\\\}"}' => undef, # Five backslashes

	     # Backslashes are always passed directly to Perl
	     '{"x20"}' => 'x20',
	     '{"\\x20"}' => ' ',	# One backslash
	     '{"\\\\x20"}' => '\\x20', # Two backslashes
	     '{"\\\\\\x20"}' => '\\ ', # Three backslashes (15)
	     '{"\\\\\\\\x20"}' => '\\\\x20', # Four backslashes
	     '{"\\\\\\\\\\x20"}' => '\\\\ ', # Five backslashes
	     '{"\\x20\\}"}' => undef, # (18)
	    );

my $i;
print "These tests are similar to those in 01-basic.t:\n";
for ($i=0; $i<@tests; $i+=2) {
    my $tmpl = Text::Template->new(TYPE => 'STRING',
            SOURCE => $tests[$i],
            DELIMITERS => ['{', '}'],
            );
    $text = $tmpl->fill_in;
    my $result = $tests[$i+1];
    ok (! defined $text && ! defined $result || $text eq $result,
            "Make sure \\ is working properly")
        ||
        print STDERR "Expected .$result., got .$text.\n";
}

exit;

