#!perl
#
# test apparatus for Text::Template module
# still incomplete.

use strict;
use warnings;
use Text::Template ('fill_in_file', 'fill_in_string');
use lib ("./t/testlib");
use Test::More tests => 13;
use File::Temp 0.14;

die "This is the test program for Text::Template version 1.45.
You are using version $Text::Template::VERSION instead.
That does not make sense.\n
Aborting"
  unless $Text::Template::VERSION == 1.45;

# (1-2) Missing source
eval {
  Text::Template->new();
};

like ($@, qr/^\QUsage: Text::Template::new(TYPE => ..., SOURCE => ...)/,
        "Missing source.")
||
print STDERR "$@\n";

eval {
  Text::Template->new(TYPE => 'FILE');
};

like ($@, qr/^\QUsage: Text::Template::new(TYPE => ..., SOURCE => ...)/,
        "Missing source (FILE)")
||
print STDERR "$@\n";

# (3) Invalid type
eval {
  Text::Template->new(TYPE => 'wlunch', SOURCE => 'fish food');
};

like ($@, qr/^\QIllegal value \`WLUNCH\' for TYPE parameter/,
        "Invalid type")
||
print STDERR "$@"; #'

my $tempfile;

{ # block to scope lexical filehandle
  my $TF = new File::Temp();
  $tempfile = $TF->filename;
}
ok(! -f $tempfile, "anonymous temp file correctly deleted by scoping");
ok(! fill_in_file($tempfile), "failure for non-existent file" );

# (4-6) File does not exist
my $o = Text::Template->new(TYPE => 'file',
                            SOURCE => $tempfile);
ok (! $o, "File does not exist");

ok (defined($Text::Template::ERROR)
        &&
        $Text::Template::ERROR =~ /^Couldn't open file/,
        "File does not exist"); #'

is (Text::Template->TTerror, $Text::Template::ERROR,
    'TTerror returns $ERROR');

# (7-8) added to test for template without closing tag

my $tmplopen = Text::Template->new(TYPE => 'STRING',
			       SOURCE => '{',
			       );
ok (! $tmplopen->compile, "compile of open ended template fails");
like ($Text::Template::ERROR, qr/^End of data inside program text that began at line /, "Open ended template fails");

ok(! fill_in_string('{'), "fill_in_string with open-ended template fails");

{
  my ( $TF1, $tempfile1 );

  $TF1 = new File::Temp();
  $tempfile1 = $TF1->filename;

  print $TF1 '{';
  close $TF1 or die "Couldn't close: $!";

  ok(! fill_in_file($tempfile1), "fill_in_file of open-ended template fails");
}

## fill_this_in() deprecated and deleted
## # (9) testing Text::Template::fill_this_in()
## eval {
##   my $text = Text::Template->fill_this_in();
## };
##
## like ($@, qr/^\QUsage: Text::Template::new(TYPE => ..., SOURCE => ...)/,
##         "Missing string and possibly other arguments")
## ||
## print STDERR "$@\n";

# (10) testing Text::Template::fill_in_file()
eval {
  my $text = fill_in_file();
};

like ($@, qr/^\QUsage: Text::Template::new(TYPE => ..., SOURCE => ...)/,
        "Missing file")
||
print STDERR "$@\n";

exit;

