#!perl
#
# test apparatus for Text::Template module
# still incomplete.

use strict;
use warnings;
use Text::Template;
use lib ("./t/testlib");
use Test::More tests => 4;
use File::Temp 0.14;

die "This is the test program for Text::Template version 1.45.
You are using version $Text::Template::VERSION instead.
That does not make sense.\n
Aborting"
  unless $Text::Template::VERSION == 1.45;

{  # define block within which filehandle $TF will be lexically scoped

  my ($template, $TF, $tempfile, $text);

  $template = Text::Template->new(
      TYPE => 'STRING',
      SOURCE => q{My process ID is {$$}}
  );

  $TF = new File::Temp();
  $tempfile = $TF->filename;

  open $TF, ">$tempfile"
    or die "Could not open test file for writing: $!; aborting";

  $text = $template->fill_in(OUTPUT => $TF);

# (1) No $text should have been constructed.  Return value should be true.
  is ($text, 1,
          "No $text should have been constructed.  Return value should be true.");

  close $TF or die "Could not close test file: $!";

  open $TF, "<$tempfile"
    or die "Could not open test file for reading: $!; aborting";
  my $t;
  { local $/; $t = <$TF>; }
  close $TF;

# (2) The text should have been printed to the file
  is ($t, "My process ID is $$",
          "The text should have been printed to the file");

}  # end block defining scope of lexical filehandle

{  # define block within which filehandle $TF1 will be lexically scoped

# (3) Define a new TT object but provide defective source
  my ($template1, $TF1, $tempfile1, $text1);
  $template1 = Text::Template->new(
      TYPE => 'STRING',
      SOURCE => q|My process ID is {$$ |
  );

  $TF1 = new File::Temp();
  $tempfile1 = $TF1->filename;

  open $TF1, ">$tempfile1"
    or die "Could not open test file for writing: $!; aborting";

  $text1 = $template1->fill_in(OUTPUT => $TF1, broken => sub { return });

  ok(! defined $text1, "fill_in() correctly failed due to defective delimiter in source");

  close $TF1 or die "Could not close test file: $!";

}  # end block defining scope of lexical filehandle

my $template2 = Text::Template->new(
      TYPE => 'STRING',
      SOURCE => q|My process ID is { die } |
  );

ok(! $template2->fill_in( broken => sub { return }), "eval error with abort");





exit;

