#!perl
#
# test apparatus for Text::Template module
# still incomplete.

use strict;
use warnings;
use Text::Template;
use lib ("./t/testlib");
use Test::More tests => 12;

BEGIN {
  eval "use Safe";
  if ($@) {
    print "1..0\n";
    exit 0;
  }
}

die "This is the test program for Text::Template version 1.45.
You are using version $Text::Template::VERSION instead.
That does not make sense.\n
Aborting"
  unless $Text::Template::VERSION == 1.45;

my $c = new Safe or die;

# Test handling of packages and importing.
$c->reval('$P = "safe root"');
our $P = $P = 'main';
$Q::P = $Q::P = 'Q';

# How to effectively test the gensymming?

my $t = new Text::Template TYPE => 'STRING', SOURCE => 'package is {$P}'
    or die;

# (1) Default behavior: Inherit from calling package, 'main' in this case.
my $text = $t->fill_in();
is ($text, 'package is main',
        "Default behavior: Inherit from calling package, 'main' in this case.");

# (2) When a package is specified, we should use that package instead.
$text = $t->fill_in(PACKAGE => 'Q');
is ($text, 'package is Q',
        "When a package is specified, we should use that package instead.");

# (3) When no package is specified in safe mode, we should use the
# default safe root.
$text = $t->fill_in(SAFE => $c);
is ($text, 'package is safe root',
        "When no package is specified in safe mode, we should use the default safe root.");

# (4) When a package is specified in safe mode, we should use the
# default safe root, after aliasing to the specified package
$text = $t->fill_in(SAFE => $c, PACKAGE => 'Q');
is ($text, 'package is Q',
        "When a package is specified in safe mode, we should use the default
        safe root, after aliasing to the specified package.");

# Now let's see if hash vars are installed properly into safe templates
$t = new Text::Template TYPE => 'STRING', SOURCE => 'hash is {$H}'
    or die;

# (5) First in default mode
$text = $t->fill_in(HASH => {H => 'good5'} );
is ($text, 'hash is good5', "First in default mode");

# (6) Now in packages
$text = $t->fill_in(HASH => {H => 'good6'}, PACKAGE => 'Q' );
is ($text, 'hash is good6', "Now in packages");

# (7) Now in the default root of the safe compartment
$text = $t->fill_in(HASH => {H => 'good7'}, SAFE => $c );
is ($text, 'hash is good7',
        "Now in the default root of the safe compartment");

# (8) Now in the default root after aliasing to a package that
# got the hash stuffed in
$text = $t->fill_in(HASH => {H => 'good8'}, SAFE => $c, PACKAGE => 'Q2' );
is ($text, 'hash is good8',
        "Now in the default root after aliasing to a package that got the hash
        stuffed in.");

# Now let's make sure that none of the packages leaked on each other.
# (9) This var should NOT have been installed into the main package
### wrapping this in no strict, as I'm not absolutely sure how this kind
### of package test would be affected by my or our
no strict;
ok (! defined $H,
        "This var should NOT have been installed into the main package");
$H=$H;
use strict;

SKIP: {

# (10) good6 was overwritten in test 7, so there's nothing to test for here.
    skip
        "good6 was overwritten in test 7, so there's nothing to test for here.",
    1;
}

# (11) this value overwrote the one from test 6.
is ($Q::H, 'good7', "this value overwrote the one from test 6.");
$Q::H = $Q::H;

# (12)
### probably should come up with a test name/comment for this
is ($Q2::H, 'good8');
$Q2::H = $Q2::H;

