#!perl
#
# Tests of basic, essential functionality
#

use strict;
use warnings;
use Text::Template;
use lib ("./t/testlib");
use Test::More tests => 32;
use File::Temp 0.14;

$X::v = $Y::v = 0;		# Suppress 'var used only once'

my $template_1 = <<EOM;
We will put value of \$v (which is "abc") here -> {\$v}
We will evaluate 1+1 here -> {1 + 1}
EOM

# Construct temporary template file for testing file operations
my $TF = new File::Temp();
my $tempfile = $TF->filename;

ok ( (open $TF, "> $tempfile"), "Tempfile opened") or &abort("Could not write tempfile $tempfile: $!" );
ok ( (print $TF $template_1), "Wrote to tempfile") or &abort("Could not write to tempfile");
close $TF or die "Could not close file after writing: $!";

# Build template from file
my $template = new Text::Template ('type' => 'FILE', 'source' => $tempfile);

ok (defined($template), "Build template from file")
  ||
  print " $Text::Template::ERROR\n";

# Fill in template from file
$X::v = "abc";
my $resultX = <<EOM;
We will put value of \$v (which is "abc") here -> abc
We will evaluate 1+1 here -> 2
EOM
$Y::v = "ABC";
my $resultY = <<EOM;
We will put value of \$v (which is "abc") here -> ABC
We will evaluate 1+1 here -> 2
EOM

my $text = $template->fill_in('package' => 'X');
is ($text, $resultX, "Fill in template from file");


# Fill in same template again
$text = $template->fill_in('package' => 'Y');
is ($text, $resultY, "Fill in same template again");


## fill_this_in() deprecated and deleted
## # (6) Simple test of 'fill_this_in'
## $text = Text::Template->fill_this_in( $template_1, 'package' => 'X');
## is ($text, $resultX, "Simple test of 'fill_this_in'");

### block beginning here become SKIP block
SKIP: {
  skip "Could not open $tempfile for reading: $!", 3 unless
    open ($TF, "< $tempfile");

  # test creation of template from filehandle
  $template = new Text::Template ('type' => 'FILEHANDLE',
				  'source' => $TF);

  ok (defined($template), "test creation of template from filehandle")
    ||
      print " $Text::Template::ERROR\n";


  # test filling in of template from filehandle
  $text = $template->fill_in('package' => 'X');
  is ($text, $resultX, "test filling in of template from filehandle");


  # test second fill_in on same template object
  $text = $template->fill_in('package' => 'Y');
  is ($text, $resultY, "test second fill_in on same template object");

  close $TF or die "Could not close $tempfile after reading: $!";
} # end of first SKIP block

# test creation of template from array
$template = new Text::Template
    ('type' => 'ARRAY',
     'source' => [
		  'We will put value of $v (which is "abc") here -> {$v}',
		  "\n",
		  'We will evaluate 1+1 here -> {1+1}',
		  "\n",
		  ]);
ok (defined($template), "test creation of template from array")
  ||
  print " Error: $Text::Template::ERROR\n";

# test filling in of template from array
$text = $template->fill_in('package' => 'X');
is ($text, $resultX, "test filling in of template from array");

# test second fill_in on same array template object
$text = $template->fill_in('package' => 'Y');
is ($text, $resultY, "test second fill_in on same array template object")
  ||
  do {
    print STDERR " $resultX\n---\n$text";
### mjd did this, so I'm loathe to change it, but
### shouldn't the following be "if (defined $text)"?
    unless (!defined($text)) { print STDERR " ERROR: $Text::Template::ERROR\n"};
  };


# test added for coverage on empty content

# Make sure \ is working properly
# Test added for version 1.11
my $tmpl = Text::Template->new(TYPE => 'STRING',
			       SOURCE => 'B{"\\}"}C{"\\{"}D',
			       );
# This should fail if the \ are not interpreted properly.
$text = $tmpl->fill_in();
is ($text, "B}C{D", q/Make sure \\is working properly/);

# Make sure \ is working properly
# Test added for version 1.11
$tmpl = Text::Template->new(TYPE => 'STRING',
			    SOURCE => qq{A{"\t"}B},
			   );
# Symptom of old problem:  ALL \ were special in templates, so
# The lexer would return (A, PROGTEXT("t"), B), and the
# result text would be AtB instead of A(tab)B.
$text = $tmpl->fill_in();

is ($text, "A\tB", q{Make sure backslash is working properly});

# Make sure \ is working properly
# Test added for version 1.11
# This is a sort of general test.
my @tests = ('{""}' => '',
	     '{"}"}' => undef,  
	     '{"\\}"}' => '}',	# One backslash
	     '{"\\\\}"}' => undef, # Two backslashes
	     '{"\\\\\\}"}' => '}', # Three backslashes
	     '{"\\\\\\\\}"}' => undef, # Four backslashes
	     '{"\\\\\\\\\\}"}' => '\}', # Five backslashes  
	     '{"x20"}' => 'x20',
	     '{"\\x20"}' => ' ',	# One backslash
	     '{"\\\\x20"}' => '\\x20', # Two backslashes
	     '{"\\\\\\x20"}' => '\\ ', # Three backslashes
	     '{"\\\\\\\\x20"}' => '\\\\x20', # Four backslashes  
	     '{"\\\\\\\\\\x20"}' => '\\\\ ', # Five backslashes
	     '{"\\x20\\}"}' => ' }', 
	    );

my $i;
for ($i=0; $i<@tests; $i+=2) {
  my $tmpl = Text::Template->new(TYPE => 'STRING',
				 SOURCE => $tests[$i],
				);
  $text = $tmpl->fill_in;
  my $result = $tests[$i+1];
  ok (! defined $text
     && ! defined $result
     || $text eq $result, q{Make sure backslash is working properly})
||
    print STDERR " expected .$result., got .$text.\n";
}


# I discovered that you cannot pass a glob ref as your filehandle.
# MJD 20010827
### block becomes skip block
SKIP: {
  skip "Could not open $tempfile for reading: $!", 3 unless
    open ($TF, "< $tempfile");

  # test creation of template from filehandle
  $template = new Text::Template ('type' => 'FILEHANDLE',
				  'source' => $TF);
  ok (defined($template), "Test creation of template from filehandle")
    ||
      print " $Text::Template::ERROR\n";

# test filling in of template from filehandle
  $text = $template->fill_in('package' => 'X');
  is ($text, $resultX, "Test filling in of template from filehandle");

# test second fill_in on same template object
  $text = $template->fill_in('package' => 'Y');
  is ($text, $resultY, "Test second fill_in on same template object");

  close $TF or die "Unable to close file: $!";
} # end second SKIP block

# Test _scrubpkg for leakiness
$Text::Template::GEN0::test = 1;
Text::Template::_scrubpkg('Text::Template::GEN0');
ok (! $Text::Template::GEN0::test, "Test _scrubpkg for leakiness");

# test added for coverage on empty content
my $tmpl32 = Text::Template->new(TYPE => 'STRING',
			       SOURCE => '{}',
			       );
ok ($tmpl32->compile, "compile empty template");

exit;

sub abort {
  unlink $tempfile;
  die $_[0];
}
