use strict;
use warnings;
use Test::More 
qw(no_plan);
# tests => 4;

use_ok('HTML::Template');
use lib("./t/testlib");
use_ok('HTML::Template27');

my (%templ, %templ27);
my ($x);

$templ{include_path} = HTML::Template->new(
    filename => './templates/include_path/a.tmpl'
);

$templ{include_path_filter} = HTML::Template->new(
    filename => './templates/include_path/a.tmpl',
    filter   => sub { ${$_[0]} =~ s/Bar/Zanzabar/g; }
);

$templ{include_path_filter_scalar} = HTML::Template->new(
    filename => './templates/include_path/a.tmpl',
    filter   => [
        {
            sub    => sub { ${$_[0]} =~ s/Bar/Zanzabar/g; },
            format => 'scalar'
        },
        {
            sub    => sub { ${$_[0]} =~ s/bar/bar!!!/g; },
            format => 'scalar'
        }
    ]
);

$templ{include_path_filter_array} = HTML::Template->new(
    filename => './templates/include_path/a.tmpl',
    filter   => {
        sub    => sub { $x = 1; for (@{$_[0]}) { $_ = "$x : $_"; $x++; } },
        format => 'array',
    }
);

$templ{scalarref} = HTML::Template->new(
    scalarref => \ "\n<TMPL_INCLUDE templates/simple.tmpl>",
);

$templ{filter_path} = HTML::Template->new(
    path     => ['templates'],
    filename => 'newline_test1.tmpl',
    filter   => sub {},
);

foreach my $u (sort keys %templ) {
    isa_ok($templ{$u}, 'HTML::Template');
}

$templ27{include_path} = HTML::Template27->new(
    filename => './templates/include_path/a.tmpl'
);

$templ27{include_path_filter} = HTML::Template27->new(
    filename => './templates/include_path/a.tmpl',
    filter   => sub { ${$_[0]} =~ s/Bar/Zanzabar/g; }
);

$templ27{include_path_filter_scalar} = HTML::Template27->new(
    filename => './templates/include_path/a.tmpl',
    filter   => [
        {
            sub    => sub { ${$_[0]} =~ s/Bar/Zanzabar/g; },
            format => 'scalar'
        },
        {
            sub    => sub { ${$_[0]} =~ s/bar/bar!!!/g; },
            format => 'scalar'
        }
    ]
);

$templ27{include_path_filter_array} = HTML::Template27->new(
    filename => './templates/include_path/a.tmpl',
    filter   => {
        sub    => sub { $x = 1; for (@{$_[0]}) { $_ = "$x : $_"; $x++; } },
        format => 'array',
    }
);

$templ27{scalarref} = HTML::Template27->new(
    scalarref => \ "\n<TMPL_INCLUDE templates/simple.tmpl>",
);

$templ27{filter_path} = HTML::Template27->new(
    path     => ['templates'],
    filename => 'newline_test1.tmpl',
    filter   => sub {},
);

foreach my $v (sort keys %templ27) {
    isa_ok($templ27{$v}, 'HTML::Template27');
}

foreach my $u (sort keys %templ) {
    is_deeply($templ{$u}, $templ27{$u}, "objects for $u have same structure");
}

=head1 NAME

t/705-cons.t 

=head1 OBJECTIVE

Fifth of 6 test files designed to guarantee that any changes made by
Phalanx (or subsequent maintainance) to C<HTML::Template::new()> return
an object with exactly the same structure as in HTML::Template v2.7.

See t/701-cons.t for further discussion.

=cut

