use strict;
use warnings;
use Test::More 
qw(no_plan);
# tests => 4;

use_ok('HTML::Template');
use lib("./t/testlib");
use_ok('HTML::Template27');

my (%templ, %templ27);


# try something a bit larger
$templ{medium} = HTML::Template->new(
    path => 'templates',
    filename => 'medium.tmpl',
);

# test a simple loop template
$templ{simpleloop} = HTML::Template->new(
    path => 'templates',
    filename => 'simple-loop.tmpl',
);

# test a simple loop template
$templ{nonames} = HTML::Template->new(
    path => 'templates',
    filename => 'simple-loop-nonames.tmpl',
);
# test a long loop template - mostly here to use timing on.
$templ{long} = HTML::Template->new(
    path => 'templates',
    filename => 'long_loops.tmpl',
);

# test a template with TMPL_INCLUDE
$templ{include} = HTML::Template->new(
    path => 'templates',
    filename => 'include.tmpl',
);

# test a template with TMPL_INCLUDE and cacheing.
$templ{include_cache} = HTML::Template->new(
    path => 'templates',
    filename => 'include.tmpl',
    cache => 1,
);

# test a simple if template
$templ{if}  = HTML::Template->new(
    path => 'templates',
    filename => 'if.tmpl',
);

# test a simple if/else template
$templ{if_else} = HTML::Template->new(
    path => 'templates',
    filename => 'ifelse.tmpl',
);

# test escapeing
$templ{escape} = HTML::Template->new(
    path => 'templates',
    filename => 'escape.tmpl',
);

foreach my $u (sort keys %templ) {
    isa_ok($templ{$u}, 'HTML::Template');
}

# try something a bit larger
$templ27{medium} = HTML::Template27->new(
    path => 'templates',
    filename => 'medium.tmpl',
);

# test a simple loop template
$templ27{simpleloop} = HTML::Template27->new(
    path => 'templates',
    filename => 'simple-loop.tmpl',
);

# test a simple loop template
$templ27{nonames} = HTML::Template27->new(
    path => 'templates',
    filename => 'simple-loop-nonames.tmpl',
);
# test a long loop template - mostly here to use timing on.
$templ27{long} = HTML::Template27->new(
    path => 'templates',
    filename => 'long_loops.tmpl',
);

# test a template with TMPL_INCLUDE
$templ27{include} = HTML::Template27->new(
    path => 'templates',
    filename => 'include.tmpl',
);

# test a template with TMPL_INCLUDE and cacheing.
$templ27{include_cache} = HTML::Template27->new(
    path => 'templates',
    filename => 'include.tmpl',
    cache => 1,
);

# test a simple if template
$templ27{if}  = HTML::Template27->new(
    path => 'templates',
    filename => 'if.tmpl',
);

# test a simple if/else template
$templ27{if_else} = HTML::Template27->new(
    path => 'templates',
    filename => 'ifelse.tmpl',
);

# test escapeing
$templ27{escape} = HTML::Template27->new(
    path => 'templates',
    filename => 'escape.tmpl',
);

foreach my $v (sort keys %templ27) {
    isa_ok($templ27{$v}, 'HTML::Template27');
}

foreach my $u (sort keys %templ) {
    is_deeply($templ{$u}, $templ27{$u}, "objects for $u have same structure");
}

=head1 NAME

t/702-cons.t

=head1 OBJECTIVE

Second of 6 test files designed to guarantee that any changes made by
Phalanx (or subsequent maintainance) to C<HTML::Template::new()> return
an object with exactly the same structure as in HTML::Template v2.7.

See t/701-cons.t for further discussion.

=cut

