use strict;
use warnings;
use Test::More 
qw(no_plan);
# tests => 4;

use_ok('HTML::Template');
use lib("./t/testlib");
use_ok('HTML::Template27');
use_ok('_Auxiliary', qw{ 
    _setup_array_fh 
});

my ($template );
my ($typetemplate, $template_string, $template_array_ref, @template_array);

my ($fh);
my (%templ, %templ27);

# test a simple template

($fh, $template_string, $template_array_ref) = 
    _setup_array_fh('templates/simple.tmpl');
@template_array = @{$template_array_ref};

$templ{template} = HTML::Template->new(
    path => 'templates',
    filename => 'simple.tmpl',
    debug => 0,
);

$templ{stemplate} = HTML::Template->new_scalar_ref(
    \$template_string,
    debug => 0,
);

$templ{atemplate} = HTML::Template->new_array_ref(
    \@template_array,
    debug => 0,
);

$templ{ftemplate} = HTML::Template->new_file(
    'simple.tmpl',
    path => 'templates',
    debug => 0,
);

$templ{fhtemplate} = HTML::Template->new_filehandle(
    $fh,
    debug => 0,
);

$templ{typetemplate} = HTML::Template->new(
    type => 'filename',
    path => 'templates',
    source => 'simple.tmpl',
    debug => 0,
);

foreach my $u (sort keys %templ) {
    isa_ok($templ{$u}, 'HTML::Template');
}

($fh, $template_string, $template_array_ref) = 
    _setup_array_fh('templates/simple.tmpl');
@template_array = @{$template_array_ref};

$templ27{template} = HTML::Template27->new(
    path => 'templates',
    filename => 'simple.tmpl',
    debug => 0,
);

$templ27{stemplate} = HTML::Template27->new_scalar_ref(
    \$template_string,
    debug => 0,
);

$templ27{atemplate} = HTML::Template27->new_array_ref(
    \@template_array,
    debug => 0,
);

$templ27{ftemplate} = HTML::Template27->new_file(
    'simple.tmpl',
    path => 'templates',
    debug => 0,
);

$templ27{fhtemplate} = HTML::Template27->new_filehandle(
    $fh,
    debug => 0,
);

$templ27{typetemplate} = HTML::Template27->new(
    type => 'filename',
    path => 'templates',
    source => 'simple.tmpl',
    debug => 0,
);

foreach my $v (sort keys %templ27) {
    isa_ok($templ27{$v}, 'HTML::Template27');
}

foreach my $u (sort keys %templ) {
    is_deeply($templ{$u}, $templ27{$u}, "objects for $u have same structure");
}

=head1 NAME

t/701-cons.t

=head1 OBJECTIVE

First of 6 test files designed to guarantee that any changes made by
Phalanx (or subsequent maintainance) to C<HTML::Template::new()> return
an object with exactly the same structure as in HTML::Template v2.7.

A large subset of the constructor calls from t/99-old-test-pl.t were
selected for testing.  Cases where the constructor was expected to fail
and were analyzed via C<eval {}> were omitted.  Cases where the
constructor involved a filter option have not yet been tested.
HTML::Template.pm v2.7 was included in F<t/testdir> and objects were
created with that version and the version under ongoing revision.

=cut

